//--------------------------------------------------------------------------------------
// File: Tutorial06.fx
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------

cbuffer cbNeverChanges
{
    matrix View;
};
    
cbuffer cbChangeOnResize
{
    matrix Projection;
};
    
cbuffer cbChangesEveryFrame
{
    matrix World;
	float4 vLightDir[2];
	float4 vLightColor[2];
	float4 vViewWorld;
	float2 vBlendWeights;
};
 

Texture2D txDecal;

SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};
RasterizerState NoCull {
	CullMode = None;
};

//--------------------------------------------------------------------------------------
struct VS_INPUT
{
    float4 Pos  : POSITION0;
    float3 Norm : NORMAL0;
    float2 Tex  : TEXCOORD0;
    float3 Offset1  : POSITION1;
    float3 NOffset1 : NORMAL1;
    float3 Offset2  : POSITION2;
    float3 NOffset2 : NORMAL2;
};

struct PS_INPUT
{
    float4 Pos : SV_POSITION;
    float2 Tex  : TEXCOORD0;
    float3 Norm : TEXCOORD1;
};


//--------------------------------------------------------------------------------------
// Vertex Shader
//--------------------------------------------------------------------------------------
PS_INPUT VS( VS_INPUT input )
{
    PS_INPUT output = (PS_INPUT)0;
    float4 Position = input.Pos;
    float3 Normal = input.Norm;
    
    Position.xyz += vBlendWeights.x * input.Offset1;
    Normal += vBlendWeights.x * input.NOffset1;
    Position.xyz += vBlendWeights.y * input.Offset2;
    Normal += vBlendWeights.y * input.NOffset2;
    
    output.Pos = mul( Position, World );
    output.Pos = mul( output.Pos, View );
    output.Pos = mul( output.Pos, Projection );
    output.Norm = mul( Normal, World );
    output.Tex = input.Tex;
    
    return output;
}


//--------------------------------------------------------------------------------------
// Pixel Shader
//--------------------------------------------------------------------------------------
float4 PS( PS_INPUT input) : SV_Target
{
    float4 finalColor = 0;
    float3 N = normalize(input.Norm.xyz);
    float3 V = normalize(vViewWorld.xyz);
    
    float4 decalColor = txDecal.Sample( samLinear, input.Tex );
    
    //do NdotL lighting for 2 lights
    for(int i=0; i<2; i++)
    {
		float3 H = normalize(vLightDir[i].xyz + V);
        finalColor += decalColor * saturate( dot( (float3)vLightDir[i], input.Norm)) * vLightColor[i] ;
        finalColor += 0.5 * pow(saturate( dot( H,N)),70) * vLightColor[i];
    }
    finalColor += 0.1*decalColor; // ambient
    finalColor.a = 1;
    return finalColor;
}

//--------------------------------------------------------------------------------------
technique10 Render
{
    pass P0
    {
        SetVertexShader( CompileShader( vs_4_0, VS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS() ) );
        
        SetRasterizerState(NoCull);
    }
}
